<?php

namespace app\merchant\controller;

use app\common\model\User as UserModel;
use app\common\model\GoodsPond as GoodsPondModel;
use app\common\model\ProxyCode as ProxyCodeModel;
use app\common\model\GoodsCategory as CategoryModel;
use app\common\model\Goods as GoodsModel;
use app\common\model\UserProxy as UserProxyModel;
use app\common\model\Complaint as ComplaintModel;
use service\MerchantLogService;
use think\Controller;
use think\Db;
use think\Exception;
use think\Request;

class Docking extends Base
{
    // 商品列表
    public function shop()
    {
        $this->setTitle('全网店铺列表');
        ////////////////// 查询条件 //////////////////
        $query = [
            'cate_id' => input('cate_id/s', ''),
            'name' => input('name/s', ''),
            'cp_authority'=>'1'
        ];
        $where = $this->genereate_where($query);

        $shopList = UserModel::alias('u')
        ->join('user_proxy p','p.user_id=u.id','left')
        ->field('p.*,u.*,p.id as pid')
        ->where($where)
        ->order('recommend desc,bond desc')
        ->paginate(30, false, [
            'query' => $query,
        ]);
        // 分页
        $page = $shopList->render();
        $this->assign('page', $page);
        $this->assign('shopList', $shopList);

        return $this->fetch();
    }

    public function goods(){
        $this->setTitle('全网对接商品列表');
        ////////////////// 查询条件 //////////////////
        $query = [
            'name' => input('name/s', ''),
            'user_id' => input('shop/s', ''),
            'cate_id' => input('cate_id/s', '')
        ];
        $where = $this->genereate_where($query);
        $sort=input('sort/s', '');
        $goodslist = GoodsPondModel::alias('a')
                    ->join('user u','u.id = a.user_id')
                    ->join('user_proxy up','up.user_id=u.id','left')
                    ->join('proxy_code p','p.id = a.auth_id')
                    ->join('goods g','a.goods_id=g.id')
                    ->field('a.*,u.*,g.*,a.sort as pondsort,a.create_at as acreate_at,up.name upname')
                    ->where('g.status','1')
                    ->where($where)
                    ->order((($sort!=''&&($sort=='desc'||$sort=='asc'))?('p.price '.$sort.','):'').'u.goods_recommend desc, a.sort desc')
                    ->paginate(30,false,[
                        'query' => $query,
                    ]);
        // 分页
        $page = $goodslist->render();
        $this->assign('pagedom', $page);
        $this->assign('page', input('page/s', ''));
        $this->assign(['msg'=>'']);
        if($sort!=''){
           $this->assign(['sort'=>$sort=='desc'?'asc':'desc']);
        }else{
            $this->assign(['sort'=>'']);
        }
        $this->assign('goodslist', $goodslist);

        return $this->fetch();
    }
    public function proxy(){
        $this->setTitle('下级代理商列表');
        ////////////////// 查询条件 //////////////////
        $query = [
            'name' => input('name/s', ''),
            'delete_at' => null,
        ];
        $where = $this->genereate_where($query);
        $children = GoodsModel::alias('a')
                    ->join('user u','u.id = a.user_id')
                    ->join('user_proxy up','up.user_id = u.id')
                    ->field('a.*,u.*,a.status as gstatus,up.name as proxy_shop_name')
                    ->where($where)
                    ->order('u.id desc')
                    ->paginate(30,false,[
                        'query' => $query,
                    ]);
        // 分页
        $page = $children->render();
        $this->assign('page', $page);
        $this->assign(['msg'=>'']);
        $this->assign('children', $children);          
        return $this->fetch();
    }

    public function setting(){
        if (!$this->request->isPost()) {
       
            $userProxy=UserProxyModel::get(['user_id'=>$this->user->id]);
            if(empty($userProxy)){
               $new=new UserProxyModel();
               $new->code='YFKDJ'.uniqid();
               $new->fee_payer=2;
               $new->user_id=$this->user->id;
               $new->save();
               $userProxy=UserProxyModel::get(['id'=>$new->id]);
            }
            $this->assign('UserProxy', $userProxy);
             return $this->fetch('shopConfig');
         }


         $userProxy=UserProxyModel::get(['user_id'=>$this->user->id]);

         $userProxy->name=input('name/s','');
         $userProxy->introduce=input('introduce/s','');
         $userProxy->qq=input('qq/s','');
         $userProxy->fee_payer=input('fee_payer/s','');
         $userProxy->save();
         $this->success('保存成功！');
    }

    public function myProxyComplaint(){

        $this->setTitle('投诉管理');
        ////////////////// 查询条件 //////////////////
        $query = [
            'type'    => input('type/s',''),
            'status'  => input('status/s',''),
        ];
        $where=[];
        if($query['status']!==''){
            $where['c.status']=$query['status'];
        }
        if($query['type']!==''){
            $where['c.type']=$query['type'];
        }
        $where['o.is_proxy']='1';
        $where['o.user_id']=$this->user->id;
        $complaints=ComplaintModel::alias('c')
        ->join('order o','o.trade_no=c.trade_no')
        ->join('user_proxy up','o.user_id=up.user_id')
        ->field('c.*,o.trade_no,o.is_proxy,up.name as up_name')
        ->where($where)->order('id desc')->paginate(30,false,[
            'query'=>$query
        ]);
        // 分页
        $page=$complaints->render();
        $this->assign('page',$page);
        $this->assign('complaints',$complaints);
        return $this->fetch('myProxyComplaint');
    }

     // 授权列表
     public function proxtgoodslist(){
        $this->setTitle('我的供货商品');
        $codelist=ProxyCodeModel::where(['user_id'=>$this->user->id,'delect_at'=>['=',0]])->select();
        
        $this->assign(['list'=>$codelist,'user'=>$this->user]);
        return $this->fetch('proxtgoodslist');
    }
   

    public function childrenProxyComplaint(){
        $this->setTitle('投诉管理');
        ////////////////// 查询条件 //////////////////
        $query = [
            'type'    => input('type/s',''),
            'status'  => input('status/s',''),
        ];
        $where=[];
        if($query['status']!==''){
            $where['c.status']=$query['status'];
        }
        if($query['type']!==''){
            $where['c.type']=$query['type'];
        }
        $where['o.is_proxy']='1';
        $where['o.proxy_user_id']=$this->user->id;
        $complaints=ComplaintModel::alias('c')
        ->join('order o','o.trade_no=c.trade_no')
        ->join('user_proxy up','o.user_id=up.user_id')
        ->field('c.*,o.trade_no,o.is_proxy,up.name as up_name')
        ->where($where)->order('id desc')->paginate(30,false,[
            'query'=>$query
        ]);
        // 分页
        $page=$complaints->render();
        $this->assign('page',$page);
        $this->assign('complaints',$complaints);
        return $this->fetch('childrenProxyComplaint');
    }

    //代理添加
    public function proxyadd()
     {
         if (!$this->request->isPost()) {
            $code_id=input('id/s', '');
            $code=ProxyCodeModel::get(['id'=>$code_id,'delect_at'=>0]);
            // 商品分类
            $categorys = CategoryModel::where(['user_id' => $this->user->id, 'status' => 1])->order('sort desc,id desc')->select();
            $this->assign('categorys', $categorys);
            $goods= GoodsModel::get(['id' => $code->goods_id]);
            $this->assign('goods', $goods);
            $this->assign('code', $code);
             return $this->fetch('proxyadd');
         }
 
         if (input('price/f', 0) < input('cost_price/f', 0)) {
            return $this->toerror('商品价格不能比进价低');
         }
 
         $code_id=input('code_id/d', 0);
         $code=ProxyCodeModel::get(['id'=>$code_id,'delect_at'=>['=',0]]);
         if(empty($code)){
            return $this->toerror('当前商品无授权');
         }
         // 检查商品价格不能低于被代理商品
         if(input('price/f', 0)<=$code->price){
            return $this->toerror('商品价格不能低于或等于商品代理价格');
         }
 
         // 不能代理自己的商品
         if($this->user->id==$code->user_id){
            return $this->toerror('不能代理自己的商品');
         }
         $hasgoods=GoodsModel::get(['user_id'=>$this->user->id,'code_id'=>$code->id]);
         if(!empty($hasgoods)){
            return  $this->toerror('该商品已代理');
         }

      
 
         $data = [
             'user_id' => $this->user->id,
             'cate_id' => input('cate_id/d', 0),
             'theme' => input('theme/s', 'default'),
             'sort' => input('sort/d', 0),
             'name' => input('name/s', ''),
             'price' => input('price/f', 0),
             'cost_price' => $code->price,
             'wholesale_discount' => 0,
             'wholesale_discount_list' => input('wholesale_discount_list/a', []),
             'limit_quantity' => input('limit_quantity/d', 1),
             'inventory_notify' => input('inventory_notify/d', 0),
             'inventory_notify_type' => input('inventory_notify_type/d', 1),
             'coupon_type' => 0,
             'sold_notify' => input('sold_notify/d', 0),
             'take_card_type' => input('take_card_type/d', 0),
             'visit_type' => input('visit_type/d', 0),
             'visit_password' => input('visit_password/s', ''),
             'contact_limit' => input('contact_limit/s', ''),
             'content' => input('content/s', ''),
             'remark' => input('remark/s', ''),
             'sms_payer' => input('sms_payer/d', 0),
             'status' => 1,
             'create_at' => $_SERVER['REQUEST_TIME'],
             'is_proxy' => 1,
             'code_id' => $code->id,
             "parent_user_id"=>$code->user_id
         ];
         // 字词检查
         $res = check_wordfilter($data['name']);
         if ($res !== true) {
            return $this->toerror('商品名包含敏感词汇“' . $res . '”！');
         }
         $res = check_wordfilter($data['content']);
         if ($res !== true) {
            return  $this->toerror('商品说明包含敏感词汇“' . $res . '”！');
         }
         $res = check_wordfilter($data['remark']);
         if ($res !== true) {
            return  $this->toerror('使用说明包含敏感词汇“' . $res . '”！');
         }
         $category = CategoryModel::get(['id' => $data['cate_id'], 'user_id' => $this->user->id]);
         if (!$category) {
            return   $this->toerror('不存在该分类！');
         }
         //检查商品价格区间
         if (sysconf('goods_min_price') > 0 && $data['price'] < sysconf('goods_min_price')) {
            return  $this->toerror('商品价格不能少于' . sysconf('goods_min_price') . '元');
         }
 
         if (sysconf('goods_max_price') > 0 && sysconf('goods_max_price') < $data['price']) {
            return  $this->toerror('商品价格不能超过' . sysconf('goods_max_price') . '元');
         }
 
         $res = $this->validate($data, 'Goods');
         if ($res !== true) {
             $this->toerror($res);
         }
         $res = GoodsModel::create($data);
         if ($res !== false) {
             //创建成功，马上创建短链接
             GoodsModel::makeLink($data['user_id'], $res->id);
             MerchantLogService::write('添加代理商品成功', '添加商品成功，商品ID:' . $res->id . ',名称:' . $res->name . ',价格:' . $res->price . ',成本价:' . $res->cost_price);
             return J(1,'添加代理商品成功');
         } else {
             $this->toerror('添加失败！');
         }
     }


   public function toerror($msg){
      return J(0,$msg);
   }
   /**
     * 生成查询条件
     */
    protected function genereate_where($params)
    {
        $where = [];
        $action = $this->request->action();
        switch ($action) {
            case 'shop':
                if ($params['cate_id']==1) {
                    $where['p.name'] = ['like', '%' . $params['name'] . '%'];
                }
                if($params['cate_id']==2){
                    $where['p.code'] = ['=', $params['name'] ];
                }
                $where['u.cp_authority'] = $params['cp_authority'];
                break;
            case 'goods':
                if($params['cate_id']==1){
                    $where['p.name'] = ['like', '%' . $params['name'] . '%'];
                }
                if($params['cate_id']==2){
                    $where['g.name'] = ['like', '%' . $params['name'] . '%'];
                }
                if($params['cate_id']==3){
                    $where['p.code'] = ['=',$params['name']];
                }
                if($params['user_id']){
                    $where['u.id'] = ['=',$params['user_id']];
                }
                $where['a.delect_at'] = 0;
                $where['g.delete_at'] = null;
                $where['u.cp_authority'] = ['=',1];
                break;
            case 'proxy':
                if ($params['name'] !== '') {
                    $where['shop_name'] = ['like', '%' . $params['name'] . '%'];
                }
                $where['a.delete_at'] = NULL;
                $where['a.parent_user_id'] = ['=',$this->user->id];
                break;
        }
        return $where;
    }
}
